/*
 * Decompiled with CFR 0.152.
 */
package com.matrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Array2D {
    private final ArrayList rows;
    private int numOfElements;

    public Array2D() {
        this.rows = new ArrayList();
        this.numOfElements = 0;
    }

    public Array2D(Array2D array) {
        this.rows = new ArrayList(array.rows);
        this.numOfElements = array.numOfElements;
    }

    public void clear() {
        this.rows.clear();
        this.numOfElements = 0;
    }

    public int size() {
        return this.numOfElements;
    }

    public int numOfRows() {
        return this.rows.size();
    }

    public int getSizeOfRow(int row) {
        return ((ArrayList)this.rows.get(row)).size();
    }

    public Object get(int row, int col) {
        return ((ArrayList)this.rows.get(row)).get(col);
    }

    public void set(int row, int col, Object newVal) {
        ((ArrayList)this.rows.get(row)).set(col, newVal);
    }

    public void addToEndOfRow(int row, Object value) {
        ((ArrayList)this.rows.get(row)).add(value);
        ++this.numOfElements;
    }

    public void addAllToEndOfRow(int row, Collection objects) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            ((ArrayList)this.rows.get(row)).add(i.next());
            ++this.numOfElements;
        }
    }

    public void addToNewFirstRow(Object value) {
        ArrayList<Object> newFirstRow = new ArrayList<Object>(1);
        newFirstRow.add(value);
        this.rows.add(0, newFirstRow);
        ++this.numOfElements;
    }

    public void addToNewLastRow(Object value) {
        ArrayList<Object> newLastRow = new ArrayList<Object>(1);
        newLastRow.add(value);
        this.rows.add(newLastRow);
        ++this.numOfElements;
    }

    public void addAllToNewLastRow(Collection objects) {
        Iterator i = objects.iterator();
        ArrayList newLastRow = new ArrayList(1);
        while (i.hasNext()) {
            newLastRow.add(i.next());
            ++this.numOfElements;
        }
        this.rows.add(newLastRow);
    }

    public void removeFirstRow() {
        this.numOfElements -= ((ArrayList)this.rows.get(0)).size();
        this.rows.remove(0);
    }

    public void removeLastRow() {
        this.numOfElements -= ((ArrayList)this.rows.get(this.rows.size() - 1)).size();
        this.rows.remove(this.rows.size() - 1);
    }

    public String toString() {
        Object outStr = "";
        for (int r = 0; r < this.rows.size(); ++r) {
            ArrayList currentRow = (ArrayList)this.rows.get(r);
            for (int c = 0; c < currentRow.size(); ++c) {
                outStr = (String)outStr + currentRow.get(c);
                outStr = c == currentRow.size() - 1 ? (String)outStr + "\n" : (String)outStr + ",";
            }
        }
        return outStr;
    }
}

