/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.util.BinaryDistance;
import com.util.DistanceFunction;
import com.util.EuclideanDistance;
import com.util.ManhattanDistance;

public class DistanceFunctionFactory {
    public static DistanceFunction EUCLIDEAN_DIST_FN = new EuclideanDistance();
    public static DistanceFunction MANHATTAN_DIST_FN = new ManhattanDistance();
    public static DistanceFunction BINARY_DIST_FN = new BinaryDistance();

    public static DistanceFunction getDistFnByName(String distFnName) {
        if (distFnName.equals("EuclideanDistance")) {
            return EUCLIDEAN_DIST_FN;
        }
        if (distFnName.equals("ManhattanDistance")) {
            return MANHATTAN_DIST_FN;
        }
        if (distFnName.equals("BinaryDistance")) {
            return BINARY_DIST_FN;
        }
        throw new IllegalArgumentException("There is no DistanceFunction for the name " + distFnName);
    }
}

