%
% Copyright 2020 Renjie Wu and Eamonn J. Keogh
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function FastDTWFailDataset(outputDir)
    rng(21052127); % 0x445457 (DTW)

    O = ones(16,1);
    Z = zeros(16,1);
    T = [1 1 -1 -1 1 1 -1 -1 1 1 -1 -1 1 1 -1 -1]';

    A = [Z; Z; Z; Z; Z; Z; T; Z];
    B = [Z; T; Z; Z; Z; Z; Z; Z];
    C = [Z; O; Z; O; Z; O; Z; O];
    
    A(17) = 0.1;
    B(end-17) = 0.1;

    C = smooth(A + randn(size(A))/20, 3);
    
    fid = fopen(fullfile(outputDir, "data.tsv"), "w");
    WriteArray(fid, 1, A);
    WriteArray(fid, 2, B);
    WriteArray(fid, 3, C);
    fclose(fid);
end

function WriteArray(fid, label, array)
    fprintf(fid, "%d", label);
    for i=1:size(array,1)
        fprintf(fid, "\t%.6f", array(i));
    end
    fprintf(fid, "\n");
end