%
% Copyright 2020 Renjie Wu and Eamonn J. Keogh
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function GenerateSyntheticFallsPairs(outputPath, startL, endL)
    fallAfid = fopen(fullfile(outputPath, sprintf("FallAs_%dto%d.tsv", startL, endL)), "w");
    fallBfid = fopen(fullfile(outputPath, sprintf("FallBs_%dto%d.tsv", startL, endL)), "w");
    
    for i=startL:endL
        [fallA, fallB] = make_synthetic_falls(i);
        fprintf(fallAfid, "%d", i);
        fprintf(fallBfid, "%d", i);
        
        for j=1:size(fallA,2)
            fprintf(fallAfid, "\t%.6f", fallA(j));
            fprintf(fallBfid, "\t%.6f", fallB(j));
        end
        
        fprintf(fallAfid, "\n");
        fprintf(fallBfid, "\n");
    end
    
    fclose(fallAfid);
    fclose(fallBfid);
end

function [fallA, fallB] = make_synthetic_falls(L)
    L = L + 1; % just to correct the 'off by one' different in presenation 
    % Make a single fall
    FALL = [zeros(1,19), sin(0:0.05:pi)*-1. zeros(1,18)];
    FALL(45:58) = FALL(45);
    % Assume L is seconds, and that we are at 100Hz

    fallA = zeros(1,100*L);
    fallA(1:100) = FALL;
    fallA = fallA + randn(size(fallA))/60;

    fallB = zeros(1,100*L);
    fallB(end-99:end) = FALL;
    fallB = fallB + randn(size(fallB))/60;
end
