%
% Copyright 2020 Renjie Wu
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function RandomWalkGenerator(length, amount, outputDir, separateFile)
    rng(21052127); % 0x445457 (DTW)
    
    figure;
    hold on;
    
    if separateFile == 0
        fid = fopen(fullfile(outputDir, "data.tsv"), "w");
    end
    
    for i=1:amount
        data = cumsum(randn(length, 1));
        data = normalize(data);
        plot(data);
        
        if separateFile == 1
            fid = fopen(fullfile(outputDir, sprintf("%d.tsv", i)), "w");
        end
        
        fprintf(fid, "%d", length);

        for j=1:size(data,1)
            fprintf(fid, "\t%.6f", data(j));
        end

        fprintf(fid, "\n");
        
        if separateFile == 1
            fclose(fid);
        end
    end
    
    if separateFile == 0
        fclose(fid);
    end
end