%
% Copyright 2020 Renjie Wu
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function caseA_Histogram(UCRArchiveDataSummryCSV)
    summary = readtable(UCRArchiveDataSummryCSV);
    dtwLearnedW = table2array(summary(:, 9));
    learnedW = cellfun(@(item) extractW(item), dtwLearnedW);
    
    length = table2array(summary(:, 7));
    % Eliminate length of "Vary"
    length = arrayfun(@(item) str2num(string(item)), length(length ~= "Vary"));
    
    figure;
    hold on;
    
    subplot(1, 2, 1);
    histogram(learnedW, 25, 'FaceAlpha', 1, 'FaceColor', [0 0.4470 0.7410]);
    xlabel("Optimal value of ({\itw}) for one-nearest neighbor classification");
    ylabel("Count");
    
    subplot(1, 2, 2);
    histogram(length, 10, 'FaceAlpha', 1, 'FaceColor', [0 0.4470 0.7410]);
    xlabel("Time series length ({\itN})");
    ylabel("Count");
end

function W = extractW(item)
    [~, token] = regexp(item, '\((\d+)\)', 'match', 'tokens');
    W = str2num(string(token));
end