%
% Copyright 2020 Renjie Wu
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function caseAandC_TimeComparsion(fastDTWcsv, cDTWcsv, fastDTWrange, cDTWrange)
    fastDTW = readtable(fastDTWcsv);
    cDTW = readtable(cDTWcsv);
    
    TfastDTW = fastDTW(:,12);
    TcDTW = cDTW(:,12);
    
    TfastDTW = TfastDTW{:,:};
    TcDTW = TcDTW{:,:};
    
    % align Y axis
    Tmax = max(max(TfastDTW), max(TcDTW));
    
    figure;
    hold on;
    
    subplot(1, 2, 1);
    plot(fastDTWrange, TfastDTW(fastDTWrange + 1));
    ylim([0 Tmax]);
    ylabel("Seconds");
    xlabel("Radius ({\itr}, integer)");
    legend("FastDTW", "location", "northwest");
    
    subplot(1, 2, 2);
    plot(cDTWrange, TcDTW(cDTWrange + 1), 'color', [0.8500 0.3250 0.0980]);
    ylim([0 Tmax]);
    xlabel("Warp window width ({\itw}, %)");
    legend("cDTW", "location", "northwest");
end